<#ibiztemplate>
TARGET=PSAPPDATAENTITY
</#ibiztemplate>

package ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.rest;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.sql.Timestamp;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.Data;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import ${pub.getPKGCodeName()}.ibizutil.domain.ActionResult;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.service.${de.codeName}Service;
import ${pub.getPKGCodeName()}.ibizutil.domain.AutoCompleteItem;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.domain.${de.codeName};
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.service.dto.${de.codeName}SearchFilter;
<#if item.getPSControls()??>
        <#list item.getPSControls() as ctrl>
            <#if ctrl.getPSAppView()?? && ctrl.getPSAppView().getRefFlag()>
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.vo.*;
            <#break>
            </#if>
    </#list>
</#if>
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.StringUtils;
import java.io.IOException;
import ${pub.getPKGCodeName()}.ibizutil.errors.BadRequestAlertException;
import org.springframework.validation.annotation.Validated;
import org.springframework.http.ResponseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import ${pub.getPKGCodeName()}.ibizutil.domain.RedirectResult;
import javax.validation.constraints.NotBlank;
import ${pub.getPKGCodeName()}.ibizutil.domain.AutoCompleteItem;
import java.math.BigInteger;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.security.access.prepost.PreAuthorize;
<#if de.hasPSDEWF()>
import ${pub.getPKGCodeName()}.ibizutil.service.RemoteWFServiceImpl;
import ${pub.getPKGCodeName()}.ibizutil.security.AuthenticationUser;
import ${pub.getPKGCodeName()}.ibizutil.domain.WFProcMemo;
import com.alibaba.fastjson.JSONArray;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
</#if>

@RestController
public class ${de.codeName}Controller{
<#if sys.getAllPSApps()??>
    <#if de.hasPSDEWF()>
    /**
    * 工作流相关
    */
    //流程定义Key
    private String strWorkflowKey = "${de.getDefaultPSDEWF().getPSWorkflow().getCodeName()}" ;

    @Autowired
	RemoteWFServiceImpl wfServiceImpl ;

    </#if>
<#list sys.getAllPSApps() as app><#comment>合并系统内所有应用实体的Controller</#comment>
<#list app.getAllPSAppDataEntities() as PSAppDataEntitie>
    <#if PSAppDataEntitie.getPSDE().getCodeName()==de.getCodeName()>
    <#assign item=PSAppDataEntitie>
    <#comment>获取实体主键属性</#comment>
    <#if de.getKeyPSDEField?? && de.getKeyPSDEField()??>
        <#assign keyfield=de.getKeyPSDEField()>
        <#if keyfield.getName?? && keyfield.getName()??>
            <#assign keyfieldname=keyfield.getName()>
        </#if>
    </#if>
    <#comment>获取实体主信息属性</#comment>
        <#if de.getMajorPSDEField?? && de.getMajorPSDEField()??>
        <#assign majorfield=de.getMajorPSDEField()>
        <#if majorfield.getName?? && majorfield.getName()??>
            <#assign majorfieldname=majorfield.getName()>
        </#if>
    </#if>

    <#comment>注入当前实体的service对象</#comment>
    <#if !P.exists(de.getCodeName(),"this")>
        @Autowired
        private ${de.codeName}Service ${de.codeName?lower_case}Service;
        /**
         * 获取服务对象
        */
        protected ${de.codeName}Service getService(){
            return this.${de.codeName?lower_case}Service;
        }
    </#if>
    <#assign appReqUrl="/" +app.getPKGCodeName()?lower_case + "/"+de.getPSSystemModule().codeName?lower_case +"/"+de.codeName?lower_case ><#comment>拼接当前应用的请求路径</#comment>
    <#assign  appName=app.getPKGCodeName()?lower_case>
    <#comment>输出实体界面行为</#comment>
    <#list de.getAllPSDEUIActions() as  UIAction>
        <#if UIAction.getPSDEAction?? && UIAction.getPSDEAction()??  && UIAction.getUIActionMode()=='BACKEND'>
    /**
     * 实体界面行为
     * @param param 参数集合
     * @return
     */
    @PostMapping(value="${appReqUrl}/uiaction/${UIAction.codeName?lower_case}")
    public ResponseEntity<JSONObject>${appName}uiaction${UIAction.codeName?lower_case?cap_first}(@RequestBody Map param) {
        String strkey="";
        JSONObject obj =new JSONObject();
        ${de.codeName} entity=new ${de.codeName}();
        <#assign field='srfkey'>
        <#if UIAction.getActionTarget()=='SINGLEKEY' || UIAction.getActionTarget()=='SINGLEDATA'>
            <#if UIAction.getValueItem()??  && ((UIAction.getValueItem())!'')!=''>
                <#assign field=UIAction.getValueItem()>
            </#if>
        Object objKey=param.get("srfkey");
        if(!StringUtils.isEmpty(objKey)){
            strkey=objKey.toString();
            entity.set${keyfield.codeName?lower_case?cap_first}(strkey);
            this.getService().get(entity);
        }
        this.getService().${srfmethodname(UIAction.getPSDEAction().codeName)}(entity);
        <#elseif UIAction.getActionTarget()=='MULTIKEY' || UIAction.getActionTarget()=='MULTIDATA'>
            <#assign field='srfkeys'>
            <#if UIAction.getParamItem()??  && ((UIAction.getParamItem())!'')!=''>
                <#assign field=UIAction.getParamItem()>
            </#if>
        String srfkeys=param.get("${field}").toString();
        String srfkeyArr[] =srfkeys.split(";");
        for(String srfkey : srfkeyArr){
            if(!StringUtils.isEmpty(srfkey)){
                entity.set${keyfield.codeName?lower_case?cap_first}(srfkey);
                this.getService().get(entity);
            }
            this.getService().${srfmethodname(UIAction.getPSDEAction().codeName)}(entity);
        }
        <#elseif UIAction.getActionTarget()=='NONE'>
        this.getService().${srfmethodname(UIAction.getPSDEAction().codeName)}(entity);
        </#if>
        obj.put("success",true);
        obj.put("info","${(UIAction.getSuccessMsg())!''}");
        obj.put("reloadData",${UIAction.isReloadData()?c});
        return ResponseEntity.ok().body(obj);
    }
        </#if>
    </#list>
    <#comment>输出实体数据重定向视图</#comment>
    <#if app.getAllPSAppViews?? && app.getAllPSAppViews()??>
        <#list app.getAllPSAppViews() as appview>
            <#if appview.isRedirectView?? && appview.isRedirectView()?? && appview.getPSDataEntity?? && appview.getPSDataEntity()??>
                <#if appview.isRedirectView()==true && appview.getPSDataEntity().getName()==item.getName() && item.getPSDE()??>
                    <#assign dataRedirectView=appview>
                    <#assign getPSDE=item.getPSDE()>
    /**
     * 重定向视图
     * @param srfkey
     * @return
     */
    @GetMapping(value="${appReqUrl}/${dataRedirectView.getPSDEViewCodeName()?lower_case}/getmodel")
    public ResponseEntity<RedirectResult>${appName}${dataRedirectView.getPSDEViewCodeName()?lower_case}Get(@Validated @NotBlank(message = "srfkey不允许为空") @RequestParam("srfkey")String srfkey) {
        RedirectResult redirectResult = new RedirectResult();
            <#comment>是否配置了实体主状态及状态属性</#comment>
            <#if getPSDE.getAllPSDEMainStates?? && getPSDE.getAllPSDEMainStates()??>
                <#if getPSDE.getDEMainStateDEFields?? && getPSDE.getDEMainStateDEFields()??>
            ${de.codeName} entity =new ${de.codeName}();
            entity.set${item.getPSDE().getKeyPSDEField().codeName?lower_case?cap_first}(srfkey);
            this.getService().get(entity);
            String majstate=this.getService().getMajState(entity);//获取实体主状态
            if(!StringUtils.isEmpty(majstate)){
                majstate="RDITEM:"+majstate;
                        <#list dataRedirectView.getPSAppViewRefs() as reditrctRefView>
                            <#if reditrctRefView.getRefPSAppView?? && reditrctRefView.getRefPSAppView()??>
                                <#assign refview=reditrctRefView.getRefPSAppView()>
                if(majstate.equals("${reditrctRefView.getName()}")){
                    redirectResult.setViewmodule("${refview.getPSAppModule().codeName}");
                    redirectResult.setViewtag("${refview.id}");
                    redirectResult.setViewname("${refview.name}");
                    redirectResult.setTitle("${refview.getCaption()}");
                    redirectResult.setOpenmode("${reditrctRefView.getOpenMode()}");
                    redirectResult.setWidth("${reditrctRefView.getWidth()}");
                    redirectResult.setHeight("${reditrctRefView.getHeight()}");
                    redirectResult.setViewparams(null);
                    redirectResult.setUrl("");
                }
                            </#if>
                        </#list>
            }
                </#if>
            </#if>
        return ResponseEntity.ok(redirectResult);
    }
                </#if>
            </#if>
        </#list>
    </#if>
    <#if de.hasPSDEWF()>
    <#comment>与控件无关的工作流方法</#comment>
    @GetMapping(value = "/${app.getPKGCodeName()?lower_case}/${de.getPSSystemModule().codeName?lower_case}/${de.codeName?lower_case}/his")
	public ResponseEntity<JSONArray> ${appName?lower_case}WfHis(@Validated @NotBlank(message = "srfkey不允许为空") @RequestParam("srfkey") String srfkey) {
		JSONArray json = new JSONArray() ;
		return ResponseEntity.ok().body(json);
	}

	@PostMapping(value = "/${app.getPKGCodeName()?lower_case}/${de.getPSSystemModule().codeName?lower_case}/${de.codeName?lower_case}/wflinks")
	public ResponseEntity<JSONArray> ${appName?lower_case}WfLinks(@RequestBody JSONObject request) throws IOException {
        String taskid =  request.getString("taskid") ;
        String srfkey =  request.getString("srfkey") ;
		JSONArray jsonArray = new JSONArray() ;
		if(taskid==null||taskid.isEmpty()){
           JSONObject  task =  wfServiceImpl.findSingleTaskByUserAndDefinitionKey(AuthenticationUser.getAuthenticationUser().getUserid(),strWorkflowKey,srfkey);
           if(task!=null){
               taskid = task.getString("id");
           }else{
               return ResponseEntity.ok().body(new JSONArray());
           }
        }
		List<JSONObject> flowElements = wfServiceImpl.findTaskLinkByTask(taskid);
		for (JSONObject sequenceFlow : flowElements) {
			JSONObject json = new JSONObject();
			json.put("id", sequenceFlow.getString("id")) ;
			json.put("name", sequenceFlow.getString("name"));

			if(sequenceFlow.getJSONObject("attributes").size()==0) {
				json.put("type", "BACKEND") ;
			}else {
				json.put("type", "FRONT") ;
//				json.put("page", sequenceFlow.getJSONObject("attributes").getJSONObject("approvalOperation").getString("value")) ;
//				json.put("mobpage", sequenceFlow.getJSONObject("attributes").getJSONObject("approvalMobOperation").getString("value")) ;
			}
			jsonArray.add(json);
		}
		return ResponseEntity.ok().body(jsonArray);
	}

	@PostMapping(value = "/${app.getPKGCodeName()?lower_case}/${de.getPSSystemModule().codeName?lower_case}/${de.codeName?lower_case}/wflink")
	public ResponseEntity<JSONObject> ${appName?lower_case}WfLink(@RequestBody JSONObject request) throws IOException{

		JSONObject ret = new JSONObject() ;
		if(!request.containsKey("args")) {
			ret.put("ret", "902") ;
			ret.put("errorInfo", "处理参数有误") ;
			return ResponseEntity.ok().body(ret);
		}
		JSONObject params = request.getJSONObject("args") ;
		String srfkey = request.getString("srfkey") ;
		String strLink = request.getString("link") ;
		String taskid =  request.getString("taskid") ;
        JSONObject curTask;
        if(taskid==null||taskid.isEmpty()){
            curTask =  wfServiceImpl.findSingleTaskByUserAndDefinitionKey(AuthenticationUser.getAuthenticationUser().getUserid(),strWorkflowKey,srfkey);
            if(curTask!=null){
                taskid = curTask.getString("id");
            }else{
                ret.put("ret", "902") ;
                ret.put("errorInfo", "处理参数有误") ;
                return ResponseEntity.ok().body(ret);
            }
        }else{
            curTask =  wfServiceImpl.findTask(taskid);
        }
		if(params==null || StringUtils.isEmpty(srfkey)||StringUtils.isEmpty(strLink)) {
			ret.put("ret", "902") ;
			ret.put("errorInfo", "处理参数有误") ;
			return ResponseEntity.ok().body(ret);
		}
    	try {
    	    ${de.codeName} entity = new ${de.codeName}();
    	    entity.set${de.getKeyPSDEField().getCodeName()?lower_case?cap_first}(srfkey);
            getService().get(entity);
            wfServiceImpl.execTaskByTaskID(taskid,strLink,entity,null,null);
			<#if de.getDefaultPSDEWF().getWFStepPSDEField()?? && de.getDefaultPSDEWF().getWFStepPSDEField().getCodeName()??>
            JSONObject activeTasks = wfServiceImpl.findActiveTaskByInstance(curTask.getString("processInstanceId"));
            String curStep = "";
            if(activeTasks.getJSONArray("data").size()>0){
                curStep = activeTasks.getJSONArray("data").getJSONObject(0).getString("name");
            }else{
                curStep = "已完成";
            }
            <#if de.getDefaultPSDEWF().getWFRetPSDEField()?? && de.getDefaultPSDEWF().getWFRetPSDEField().getCodeName()??>
            entity.set${de.getDefaultPSDEWF().getWFRetPSDEField().getCodeName()?lower_case?cap_first}(WFProcMemo.create(entity.get("${de.getDefaultPSDEWF().getWFRetPSDEField().getCodeName()}")).commit(entity.get("${de.getDefaultPSDEWF().getWFStepPSDEField().getCodeName()}"),AuthenticationUser.getAuthenticationUser().getUserid(),AuthenticationUser.getAuthenticationUser().getPersonname()).getContent(true));
            </#if>
            entity.set${de.getDefaultPSDEWF().getWFStepPSDEField().getCodeName()?lower_case?cap_first}(curStep);
            getService().save(entity);
            </#if>
    		ret.put("ret", "0") ;
    		return ResponseEntity.ok().body(ret);
    	}
		catch (Exception e) {
			ret.put("ret", "903") ;
			ret.put("errorInfo", "处理参数有误") ;
			return ResponseEntity.ok().body(ret);
		}
	}
	</#if>
    <#if item.getPSControls()??>
    <#assign ctrltypes=['FORM','GRID','SEARCHFORM','MOBMDCTRL','DRBAR','DATAVIEW','CALENDAR','MULTIEDITVIEWPANEL','WIZARDPANEL','LIST','CHART']>
    <#comment>输出上述[ctrltypes]中定义的视图部件</#comment>
<#--    <#list ctrltypes as ctrltype>-->
        <#list item.getPSControls() as ctrl>
            <#if ctrl.getPSAppView()?? && ctrl.getPSAppView().getRefFlag()>
<#--            <#if ctrl.getControlType() == ctrltype>-->
                <#if ctrltypes?seq_contains(ctrl.getControlType())>
                <#assign ctrltype = ctrl.getControlType()>
                <#if ctrltype=='FORM'>
            <#comment>输出表单项更新</#comment>
            <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),"_updateformitem_")>
                <#if ctrl.getPSDEFormItemUpdates?? && ctrl.getPSDEFormItemUpdates()??>
                    <#list ctrl.getPSDEFormItemUpdates() as formItemUpdate>
     /**
     * 表单项更新
     * @param form vo对象
     * @return
     */
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/updateformitem/${formItemUpdate.codeName?lower_case}")
    public ResponseEntity<JSONObject>${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}_updateformitem_${formItemUpdate.getCodeName()}(@RequestBody ${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()} form) throws com.fasterxml.jackson.core.JsonProcessingException {
            ${de.codeName} entity=form.to${de.codeName}();
            this.getService().${srfmethodname(formItemUpdate.getPSDEAction().getCodeName())}(entity);
            form.from${de.codeName}(entity);
            return ResponseEntity.ok().body(form.${formItemUpdate.getCodeName()?lower_case}FormItemUpdateFilter());//VO值过滤,只输出表单项更新的明细项
    }
                    </#list>
                </#if>
            </#if>
            <#comment>输出表单部件行为</#comment>
            <#assign handler=ctrl.getPSAjaxControlHandler()>
            <#if handler?? && handler.getPSAjaxHandlerActions()??>

<#if de.hasPSDEWF()>
<#if !P.exists(ctrltype,ctrl.getCodeName(),'WFACTION')>
    /**
     * 工作流步骤
     */
    @PostMapping(value = "/${app.getPKGCodeName()?lower_case}/${de.getPSSystemModule().codeName?lower_case}/${de.codeName?lower_case}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/viewwfstep")
	public ResponseEntity<byte[]> ${appName?lower_case}${ctrl.getCodeName()?lower_case?cap_first}${srfclassname(ctrltype)?lower_case}Viewwfstep(@RequestBody JSONObject request) throws IOException {
		String taskId = request.getString("taskid");
		JSONObject task = wfServiceImpl.findTask(taskId);
		String instanceID = task.getString("processInstanceId");
		InputStream stream = wfServiceImpl.getProcessInstanceDiagram(instanceID) ;
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.set("Content-Type", "image/png");
		try {
			if(stream!=null)
				return new ResponseEntity<>(org.apache.commons.io.IOUtils.toByteArray(stream), responseHeaders, HttpStatus.OK);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null ;
	}

    /**
     * 工作流启动
     */
	@PostMapping(value = "/${app.getPKGCodeName()?lower_case}/${de.getPSSystemModule().codeName?lower_case}/${de.codeName?lower_case}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/wfstart")
	public ResponseEntity<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}> ${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Start(@Validated @RequestBody ${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()} form) {
		${de.codeName} entity =form.to${de.codeName}();
        getService().save(entity);
        form.from${de.codeName}(entity);
		form.setSrfuf("1");
		try {
            JSONObject variables = new JSONObject();
            variables.put("logicName","${de.getLogicName()}");
            variables.put("majortext",entity.get${de.getMajorPSDEField().getCodeName()?lower_case?cap_first}());
            JSONObject instance = wfServiceImpl.startByDifinitionKey(strWorkflowKey, entity.get${de.getKeyPSDEField().getCodeName()?lower_case?cap_first}(), AuthenticationUser.getAuthenticationUser(),entity,variables,null);
			<#if de.getDefaultPSDEWF().getWFStepPSDEField()?? && de.getDefaultPSDEWF().getWFStepPSDEField().getCodeName()??>
            JSONObject activeTasks = wfServiceImpl.findActiveTaskByInstance(instance.getString("id"));
            String curStep = activeTasks.getJSONArray("data").getJSONObject(0).getString("name");
            entity.set${de.getDefaultPSDEWF().getWFStepPSDEField().getCodeName()?lower_case?cap_first}(curStep);
            getService().save(entity);
            </#if>
			return ResponseEntity.ok().body(form);
    	}
		catch (Exception e) {
		    e.printStackTrace();
		    if(e.getMessage()!=null && !e.getMessage().isEmpty()){
                throw new BadRequestAlertException(e.getMessage(),"111","900") ;
            }
			throw new BadRequestAlertException("启动流程异常","111","900") ;
		}
	}

</#if>
</#if>
                <#list handler.getPSAjaxHandlerActions() as action>
                <#if action.getPSDEAction()??>
                <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),action.getPSDEAction().getName())>
                    <#assign actionmode=action.getPSDEAction().getActionMode()>
    <#if actionmode=='CREATE' || actionmode=='UPDATE' || actionmode=='GETDRAFT' || actionmode=='UNKNOWN'>
        <#comment>Security权限注解</#comment>
        <#if actionmode=='CREATE' || actionmode=='GETDRAFT'><#comment>新建或更新表单时，启动校验逻辑</#comment>
        @PreAuthorize("hasPermission('','',{'${de.getCodeName()}','CREATE',this.getEntity()})")
        <#elseif actionmode=='UPDATE'>
        @PreAuthorize("hasPermission(#form.srfkey,'',{'${de.getCodeName()}','UPDATE',this.getEntity()})")
        </#if>
        @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/${action.getPSDEAction().getCodeName()?lower_case}")
        <#if actionmode=='CREATE' || actionmode=='UPDATE'><#comment>新建或更新表单时，启动校验逻辑</#comment>
        public ResponseEntity<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}${action.getPSDEAction().getCodeName()}(@Validated @RequestBody ${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()} form){
        <#else>
        public ResponseEntity<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}${action.getPSDEAction().getCodeName()}(@RequestBody ${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()} form){
        </#if>
    <#if actionmode=='GETDRAFT'>
        if(!StringUtils.isEmpty(form.getSrfsourcekey()))
        {
            ${de.codeName} sourceEntity =new ${de.codeName}();
            sourceEntity.set${de.getKeyPSDEField().codeName?lower_case?cap_first}(form.getSrfsourcekey());
            this.getService().get(sourceEntity);

            ${de.codeName} targetEntity =new ${de.codeName}();
            sourceEntity.copyTo(targetEntity);
            form.from${de.codeName}(targetEntity,false);
            form.setSrfuf("0");
            return ResponseEntity.ok().body(form);
         }
    </#if>
            ${de.codeName} entity =form.to${de.codeName}();
    <#if actionmode=='UPDATE'>
            this.getService().get(entity);//获取entity完整数据
            BeanCopier copier=BeanCopier.create(form.getClass(),entity.getClass(), false);//vo数据覆盖do数据
            copier.copy(form,entity,null);//执行覆盖操作
    </#if>
            getService().${action.getPSDEAction().getCodeName()?uncap_first}(entity);
            form.from${de.codeName}(entity);
    <#if actionmode=='UPDATE'||actionmode=='CREATE'>
            form.setSrfuf("1");
    <#else>
            form.setSrfuf("0");
    </#if>
            return ResponseEntity.ok().body(form);
        }
    </#if>
    <#if actionmode=='READ' ||actionmode=='DELETE'>
        <#comment>Security权限注解</#comment>
    @PreAuthorize("hasPermission(#srfkey,'',{'${de.codeName}','${actionmode}',this.getEntity()})")
    @GetMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/${action.getPSDEAction().getCodeName()?lower_case}")
    public ResponseEntity<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}${action.getPSDEAction().getCodeName()}(@Validated @NotBlank(message = "srfkey不允许为空") @RequestParam("srfkey")${srfjavatype(de.getKeyPSDEField().stdDataType)} srfkey){
        ${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()} form=new ${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}();
        ${de.codeName} entity = new ${de.codeName}();
        entity.set${de.getKeyPSDEField().codeName?lower_case?cap_first}(srfkey);
        <#if actionmode=='READ'>
        getService().get(entity);
        form.setSrfuf("1");
        </#if>
        <#if actionmode=='DELETE'>
        getService().remove(entity);
        form.setSrfuf("0");
        </#if>
        form.from${de.codeName}(entity);
        return ResponseEntity.ok().body(form);
    }
    </#if>
                </#if>
                </#if>
                </#list>
            </#if>
            <#comment>输出表单项后台逻辑(AC)</#comment>
            <#if ctrl.getPSDEFormItems()??>
                <#list ctrl.getPSDEFormItems() as formitem>
                    <#if formitem.getItemHandlerType()?? && formitem.getItemHandlerType()?length gt 0>
                    <#if !P.exists(appName+ctrltype,ctrl.getCodeName()+formitem.getName(),"_handler_")>
    <#if formitem.getItemHandlerType() == "PickupText" || formitem.getItemHandlerType() == "AC">
        <#if formitem.getRefPSDEDataSet()?? && formitem.getRefPSDEDataSet().getPSDataEntity()??>
            <#assign refdataset=formitem.getRefPSDEDataSet()>
            <#assign refde=formitem.getRefPSDEDataSet().getPSDataEntity()>
        <#elseif formitem.getRefPSDEACMode()?? && formitem.getRefPSDEACMode().getPSDataEntity()??>
            <#assign refde=formitem.getRefPSDEACMode().getPSDataEntity()>
        <#elseif formitem.getPSDEFFormItem()?? && formitem.getPSDEFFormItem().getRefPSDataEntity()??>
            <#assign refde=formitem.getPSDEFFormItem().getRefPSDataEntity()>
            <#assign refdataset=formitem.getPSDEFFormItem().getRefPSDEDataSet()>
        </#if>
    <#comment>引入关联实体</#comment>
    <#if refde?? && refde.getId() != de.getId()>
        <#if !P.exists("RefService_",refde.getCodeName()+"_",refde.codeName?lower_case+"Service")>
    @Autowired
    private ${pub.getPKGCodeName()}.${refde.getPSSystemModule().codeName?lower_case}.service.${refde.getCodeName()}Service ${refde.codeName?lower_case}Service;
        </#if>
    </#if>
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/${formitem.getName()?lower_case}/ac")
    public ResponseEntity<List<AutoCompleteItem>> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}_${formitem.getName()?lower_case}_ac(@RequestBody ${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()} form){
        List<AutoCompleteItem> list =new ArrayList<>();
    <#if refde??>
        ${pub.getPKGCodeName()}.${refde.getPSSystemModule().codeName?lower_case}.service.dto.${refde.getCodeName()}SearchFilter searchFilter = new ${pub.getPKGCodeName()}.${refde.getPSSystemModule().codeName?lower_case}.service.dto.${refde.getCodeName()}SearchFilter();
        ${de.codeName} entity =form.to${de.codeName}();
        <#comment>自填数据查询：外键|选择下拉；</#comment>
        String queryField=entity.get${formitem.getName()?lower_case?cap_first}();
        <#if formitem.getPSDEField?? && formitem.getPSDEField()??>
            <#if formitem.getItemHandlerType() == "PickupText">
        if(!StringUtils.isEmpty(queryField))
            searchFilter.getSelectCond().like("${refde.getMajorPSDEField().name?lower_case}",queryField);
            </#if>
        </#if>
    <#if refdataset?? && refdataset.getADPSDEDQConditions()??>
        ${refde.getCodeName()}SearchFilter.ActiveData activeData = new ${refde.getCodeName()}SearchFilter.ActiveData();
        ${de.codeName} ${de.codeName?uncap_first} = to${de.codeName}(${srfparamname(ctrl.getCodeName())});
            <#list refdataset.getADPSDEDQConditions() as cond>
        Object value${cond_index?c} = this.getService().getActiveDataField(${de.codeName?uncap_first},"${srfjavastring(cond.getCondValue())}","${cond.getPSDEField().getPSDataEntity().getName()}","${cond.getPSDEField().getName()}","${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}_${formitem.getName()?lower_case}");
        if(value${cond_index?c}!=null){
            BeanUtils.setProperty(activeData,"${srfjavastring(cond.getCondValue())?lower_case}",value${cond_index?c});
        }
            </#list>
        searchFilter.setActivedata(activeData);
    </#if>
    <#if refdataset??>
        Page<${pub.getPKGCodeName()}.${refde.getPSSystemModule().codeName?lower_case}.domain.${refde.getCodeName()}> searchResult = ${refde.codeName?lower_case}Service.search${refdataset.codeName}(searchFilter);
    <#else>
        Page<${pub.getPKGCodeName()}.${refde.getPSSystemModule().codeName?lower_case}.domain.${refde.getCodeName()}> searchResult = ${refde.codeName?lower_case}Service.searchDefault(searchFilter);
    </#if>
    <#comment>自填数据组装返回前台，选择下拉的返回值取自填模式的值属性和文本属性；外键则取外键值和外键值文本</#comment>
        for(${pub.getPKGCodeName()}.${refde.getPSSystemModule().codeName?lower_case}.domain.${refde.getCodeName()} entity2 :searchResult.getRecords()) {
                <#if formitem.getRefPSDEACMode()??>
                    <#assign acmode=formitem.getRefPSDEACMode()>
            AutoCompleteItem acItem =new AutoCompleteItem();
                    <#if acmode.getValuePSDEF?? && acmode.getValuePSDEF()??>
            acItem.setValue(entity2.get${acmode.getValuePSDEF().codeName?lower_case?cap_first}());
                    <#else>
                        <#if refde??>
            acItem.setValue(entity2.get${refde.getKeyPSDEField().codeName?lower_case?cap_first}());
                        </#if>
                    </#if>
                    <#if acmode.getTextPSDEF?? && acmode.getTextPSDEF()??>
            acItem.setText(entity2.get${acmode.getTextPSDEF().codeName?lower_case?cap_first}());
            acItem.setRealtext(entity2.get${acmode.getTextPSDEF().codeName?lower_case?cap_first}());
                    <#else>
                        <#if refde??>
            acItem.setText(entity2.get${refde.getMajorPSDEField().codeName?lower_case?cap_first}());
            acItem.setRealtext(entity2.get${refde.getMajorPSDEField().codeName?lower_case?cap_first}());
                        </#if>
                    </#if>
            list.add(acItem);
                <#else>
            //没有引用自填模式
                </#if>
        }
    </#if>
        return ResponseEntity.ok().body(list);
    }
    </#if>
                        </#if>
                    </#if>
                </#list>
            </#if>
        </#if>
        <#comment>输出表格部件行为</#comment>
        <#if ctrltype=='GRID'>
        <#assign handler=ctrl.getPSAjaxControlHandler()>
        <#if handler?? && handler.getPSAjaxHandlerActions()??>
            <#list handler.getPSAjaxHandlerActions() as action>
            <#if action.getPSDEAction()??>
            <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),action.getPSDEAction().getName())>
            <#assign actionmode=action.getPSDEAction().getActionMode()>
            <#if actionmode=='CREATE' || actionmode=='UPDATE' || actionmode=='GETDRAFT' >
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/${action.getPSDEAction().getCodeName()?lower_case}")
    public ${de.getCodeName()} ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}${action.getPSDEAction().getCodeName()}(@Validated ${de.getCodeName()} ${srfparamname(ctrl.getCodeName())}Item){
        return ${srfparamname(ctrl.getCodeName())}Item;
    }
            </#if>
            <#if actionmode=='DELETE'  >
    @PreAuthorize("hasPermission('',{'${de.codeName}','DELETE',this.getEntity(),#args})")
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/${action.getPSDEAction().getCodeName()?lower_case}")
    public ResponseEntity<${de.codeName}> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}${action.getPSDEAction().getCodeName()}(@Validated @RequestBody Map args){
        ${de.codeName} entity =new ${de.codeName}();
        if ( !StringUtils.isEmpty(args.get("srfkeys"))) {
            String srfkeys=args.get("srfkeys").toString();
            String srfkeyArr[] =srfkeys.split(";");
            for(String srfkey : srfkeyArr)
            {
                if(!StringUtils.isEmpty(srfkey)){
                <#if  srfjavatype(de.getKeyPSDEField().stdDataType)='BigInteger'>
                entity.set${de.getKeyPSDEField().codeName?lower_case?cap_first}(new BigInteger(srfkey));
                <#else>
                entity.set${de.getKeyPSDEField().codeName?lower_case?cap_first}(srfkey);
                </#if>
                this.getService().remove(entity);
                }
            }
        }
        return ResponseEntity.ok().body(entity);
    }
            </#if>
            </#if>
            </#if>
            </#list>
        </#if>
        <#comment>表格数据导出</#comment>
        <#if !P.exists("RefService_","IBZFILEService","")>
    @org.springframework.beans.factory.annotation.Value("${r'${ibiz.filePath}'}")
    private String strFilePath;
    @Autowired
    private ${pub.getPKGCodeName()}.ibizutil.service.IBZFILEService ibzfileService;
        </#if>
        <#assign GridDataSet=((ctrl.getPSAjaxControlHandler().getPSDEDataSet().getCodeName())!'Default')>
        <#if !P.exists(ctrltype+ctrl.getCodeName(),"exportdataSearch",GridDataSet)>
    /**
     * [${ctrl.getCodeName()?lower_case}]表格数据导出
     * @param searchFilter
     * @return
     * @throws IOException
     * @throws
     */
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/exportdata/search${GridDataSet?lower_case}")
    public ResponseEntity<Page<JSONObject>> ${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}ExportDataSearch${GridDataSet}(@Validated @RequestBody ${de.codeName}SearchFilter searchFilter) throws IOException, jxl.write.WriteException {
        String fileid=com.baomidou.mybatisplus.core.toolkit.IdWorker.get32UUID();
        String localPath=${appName}ExportDataInit(fileid);//输出文件相对路径
        Page<${de.codeName}> searchResult = this.getService().search${GridDataSet}(searchFilter);//1.查询表格数据
        List<Map<String,Object>> datas=${de.codeName}_Grid_${ctrl.codeName}.pageToListDatas(searchResult);//2.将数据转换成list
        List<Map<String,String>> colnums=${de.codeName}_Grid_${ctrl.codeName}.getGridColumnModels();//3.获取表格列头
        java.io.File outputFile=${pub.getPKGCodeName()}.ibizutil.helper.DEDataExportHelper.getInstance().output(strFilePath+localPath,colnums,datas,new ${de.codeName}().getDictField(),new ${de.codeName}().getDateField());//4.生成导出文件
        ${pub.getPKGCodeName()}.ibizutil.helper.DEDataExportHelper.getInstance().saveFileData(outputFile,localPath,fileid,ibzfileService); //5.保存file表记录
        String strDownloadUrl =String.format("ibizutil/download/"+fileid);//6.回传文件路径给前台
        Page<JSONObject> resultObj=${de.codeName}_Grid_${ctrl.codeName}.getResultPage(searchResult,strDownloadUrl);//7.获取输出对象
            return ResponseEntity.ok().body(resultObj);
    }
        </#if>
        <#if !P.exists(appName,ctrltype,"exportdata")>
    /**
     * 表格数据导出
     * @param fileid
     * @return
     */
    private String ${appName}ExportDataInit(String fileid) {
        java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat("yyyyMMdd");
        String filepath=dateFormat.format(new java.util.Date())+ java.io.File.separator;
        java.text.SimpleDateFormat dateFormat2 = new java.text.SimpleDateFormat("yyyyMMddHHmmss");
        String strTempFileName = fileid+"-"+dateFormat2.format(new java.util.Date())+".xls";
        java.io.File file =new java.io.File(strFilePath+filepath);
        if(!file.exists())
           file.mkdirs();
        return filepath+strTempFileName;
    }
        </#if>
    </#if>
    <#comment>输出表格列表部件数据查询</#comment>
    <#if ctrltype=='GRID' ||ctrltype=='MOBMDCTRL'||ctrltype=='DATAVIEW'>
    <#assign handler=ctrl.getPSAjaxControlHandler()>
    <#if handler?? && !P.exists(appName+ctrltype,ctrl.getCodeName(),'SEARCH'+handler.getPSDEDataSet().getName())>
    @PreAuthorize("hasPermission('',{'${de.codeName}','${handler.getPSDEDataSet().getName()}','READ',this.getEntity(),#searchFilter})")
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/search${handler.getPSDEDataSet().getCodeName()?lower_case}")
    public ResponseEntity<Page<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}>> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Search${handler.getPSDEDataSet().getCodeName()}(@Validated @RequestBody ${de.getCodeName()}SearchFilter searchFilter){
            Page<${de.getCodeName()}> searchResult = this.getService().search${handler.getPSDEDataSet().getCodeName()}(searchFilter);
            Page<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}> searchResult_vo_data =${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}.from${de.getCodeName()}(searchResult);
                    return ResponseEntity.ok().body(searchResult_vo_data);
    }
        <#assign handler=ctrl.getPSAjaxControlHandler()>
        <#if handler?? && handler.getPSAjaxHandlerActions()?? && ctrltype=='MOBMDCTRL'>
            <#list handler.getPSAjaxHandlerActions() as action>
            <#if action.getPSDEAction()??>
                <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),action.getPSDEAction().getName())>
                    <#assign actionmode=action.getPSDEAction().getActionMode()>
                    <#if actionmode=='DELETE'  >
    /**
     * 移动端列表删除
     * @param
     * @return
     */
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/${action.getPSDEAction().getCodeName()?lower_case}")
    public ResponseEntity<${de.codeName}> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}${action.getPSDEAction().getCodeName()}(@Validated @RequestBody Map args){
        ${de.codeName} entity =new ${de.codeName}();
        if ( !StringUtils.isEmpty(args.get("srfkeys"))) {
            String srfkeys=args.get("srfkeys").toString();
            String srfkeyArr[] =srfkeys.split(";");
            for(String srfkey : srfkeyArr)
            {
                if(!StringUtils.isEmpty(srfkey)){
                <#if  srfjavatype(de.getKeyPSDEField().stdDataType)='BigInteger'>
                entity.set${de.getKeyPSDEField().codeName?lower_case?cap_first}(new BigInteger(srfkey));
                <#else>
                entity.set${de.getKeyPSDEField().codeName?lower_case?cap_first}(srfkey);
                </#if>
                this.getService().remove(entity);
                }
            }
        }
        return ResponseEntity.ok().body(entity);
    }
                    </#if>
                </#if>
            </#if>
            </#list>
        </#if>
    </#if>
    </#if>
    <#comment>实体列表</#comment>
    <#if ctrltype=='LIST'>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'SEARCH'+ctrl.getPSDEDataSet().getName())>
    /**
     * 移动端列表
     * @param searchFilter
     * @return
     */
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/search${ctrl.getPSDEDataSet().getCodeName()?lower_case}")
    public ResponseEntity<Page<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}>> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Search${ctrl.getPSDEDataSet().getCodeName()}(@Validated @RequestBody ${de.getCodeName()}SearchFilter searchFilter){
        Page<${de.getCodeName()}> searchResult = this.getService().search${ctrl.getPSDEDataSet().getCodeName()}(searchFilter);
        Page<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}> searchResult_vo_data =${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}.from${de.getCodeName()}(searchResult);
        return ResponseEntity.ok().body(searchResult_vo_data);
    }
        </#if>
    </#if>
    <#comment>搜索表单</#comment>
    <#if ctrltype=='SEARCHFORM'>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'LOAD')>
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/load")
    public void ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Load(){

    }
        </#if>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'LOADDRAFT')>
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/loaddraft")
    public ResponseEntity<${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()}> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}LoadDraft(@Validated @RequestBody ${de.getCodeName()}_${srfclassname(ctrltype)}_${ctrl.getCodeName()} searchform){
            ${de.getCodeName()}SearchFilter searchfilter =searchform.to${de.getCodeName()}SearchFilter();
        searchform.from${de.getCodeName()}SearchFilter(searchfilter);
        return ResponseEntity.ok().body(searchform);
    }
        </#if>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'SEARCH')>
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/search")
    public void ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Search(){

    }
        </#if>
    </#if>
    <#comment>关系区</#comment>
    <#if ctrltype=='DRBAR'>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'GET')>
    @GetMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/get")
    public ResponseEntity<JsonNode> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Get(@Validated @NotBlank(message = "srfkey不允许为空") ${srfjavatype(de.getKeyPSDEField().stdDataType)} srfkey){
        InputStream in = this.getClass().getResourceAsStream("/${srfclassname(ctrltype)?lower_case}/${de.getCodeName()?lower_case}_${ctrl.codeName?lower_case}.json");
        JsonNode jsonNode;
        try {
            jsonNode = new ObjectMapper().readTree(in);
        } catch (IOException e) {
            throw new BadRequestAlertException("[defaultdrbar]操作发生错误"+e,"","");
        }
        return ResponseEntity.ok().body(jsonNode);
    }
        </#if>
    </#if>
    <#comment>视图向导</#comment>
    <#if ctrltype=='WIZARDPANEL'>
        <#list ctrl.getPSDEEditForms() as editform>
            <#if editform.getPSDEWizardForm().isFirstForm()==true>
                <#assign firstForm=editform>
                <#break>
            </#if>
        </#list>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'Init')>
    /**
     * 向导-初始化
     * @param form
     * @return
     */
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/init")
    public ResponseEntity<${de.getCodeName()}_${srfclassname(firstForm.getControlType())}_${firstForm.getCodeName()}> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Init( @RequestBody ${de.getCodeName()}_${srfclassname(firstForm.getControlType())}_${firstForm.getCodeName()} form){
                    ${de.getCodeName()} entity =form.to${de.getCodeName()}();
        getService().create(entity);
        form.from${de.getCodeName()}(entity);
        form.setSrfuf("1");
        return ResponseEntity.ok().body(form);
    }
        </#if>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'Finish')>
    /**
     * 向导-完成
     * @param form
     * @return
     */
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/finish")
    public ResponseEntity<${de.getCodeName()}_${srfclassname(firstForm.getControlType())}_${firstForm.getCodeName()}> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Finish(@Validated @RequestBody ${de.getCodeName()}_${srfclassname(firstForm.getControlType())}_${firstForm.getCodeName()} form){
                    ${de.getCodeName()} entity =form.to${de.getCodeName()}();
        getService().save(entity);
        form.from${de.getCodeName()}(entity);
        form.setSrfuf("1");
        return ResponseEntity.ok().body(form);
    }
        </#if>
    </#if>
    <#comment>多编辑表单-查询</#comment>
    <#if ctrltype=='MULTIEDITVIEWPANEL'>
        <#assign handler=ctrl.getPSAjaxControlHandler()>
        <#if handler?? && !P.exists(appName+ctrltype,ctrl.getCodeName(),'SEARCH'+handler.getPSDEDataSet().getName())>
    /**
     * 多编辑表单
     * @param searchFilter
     * @return
     */
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/search${handler.getPSDEDataSet().getCodeName()?lower_case}")
    public ResponseEntity<Page<com.alibaba.fastjson.JSONObject>> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Search${handler.getPSDEDataSet().getCodeName()}(@Validated @RequestBody ${de.getCodeName()}SearchFilter searchFilter){
        Page<${de.getCodeName()}> searchResult = this.getService().searchDefault(searchFilter);
        Page<com.alibaba.fastjson.JSONObject> targetpage = new Page<com.alibaba.fastjson.JSONObject>(searchResult.getCurrent(), searchResult.getSize(), searchResult.getTotal(), searchResult.isSearchCount());
        List<com.alibaba.fastjson.JSONObject> records = new ArrayList<com.alibaba.fastjson.JSONObject>();
        for (${de.getCodeName()} source : searchResult.getRecords()) {
            com.alibaba.fastjson.JSONObject obj =new com.alibaba.fastjson.JSONObject();
            obj.put("srfkey",source.get${keyfieldname?lower_case?cap_first}());
            obj.put("srfmajortext",source.get${majorfieldname?lower_case?cap_first}());
            records.add(obj);
        }
        targetpage.setAsc(searchResult.ascs());
        targetpage.setDesc(searchResult.descs());
        targetpage.setOptimizeCountSql(searchResult.optimizeCountSql());
        targetpage.setRecords(records);

        return ResponseEntity.ok().body(targetpage);
    }
        </#if>
    </#if>
    <#comment>日历部件</#comment>
    <#if ctrltype=='CALENDAR'>
        <#list ctrl.getPSSysCalendarItems() as calendards>
            <#assign calendarEntity=calendards.getPSDataEntity()>
            <#if !P.exists("RefService_",calendarEntity.getCodeName()+"_",calendarEntity.codeName?lower_case+"Service")>
            @Autowired
            private ${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.service.${calendarEntity.getCodeName()}Service ${calendarEntity.codeName?lower_case}service;
            </#if>
        </#list>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'SEARCH')>
        /**
         * 日历部件
         * @param calendar
         * @return
         */
        @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/search")
        public ResponseEntity<Page<${de.getCodeName()}_Calendar_${ctrl.getCodeName()}>> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Search(@Validated @RequestBody ${de.getCodeName()}_Calendar_${ctrl.getCodeName()} calendar){
            List<${de.getCodeName()}_Calendar_${ctrl.getCodeName()}> records=new ArrayList<>();
                        <#list ctrl.getPSSysCalendarItems() as calendards>
                            <#assign calendarEntity=calendards.getPSDataEntity()>
            Page<${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.domain.${calendarEntity.getCodeName()}> ${calendarEntity.codeName?lower_case}SearchResult = ${calendarEntity.codeName?lower_case}service.searchDefault(calendar.get${calendarEntity.codeName}SearchFilter(calendar));
            calendar.add${calendarEntity.codeName}ToRecords(${calendarEntity.codeName?lower_case}SearchResult,records);//日历数据源[${calendards.name}]数据查询
                        </#list>
            Page<${de.getCodeName()}_Calendar_${ctrl.getCodeName()}> searchResult_vo_data=calendar.addRecordsToPage(records);//将日历数据源转换成vo对象输出
            return ResponseEntity.ok().body(searchResult_vo_data);
        }
        </#if>
    </#if>
    <#comment>图表部件</#comment>
    <#if ctrltype=='CHART'>
        <#if !P.exists(appName+ctrltype,ctrl.getCodeName(),'SEARCH')>
    /**
     * 图表部件
     * @param
     * @return
     */
    @PostMapping(value="${appReqUrl}/${ctrl.getCodeName()?lower_case}${srfclassname(ctrltype)?lower_case}/search")
    public ResponseEntity<Page<JSONObject>> ${appName}${srfmethodname(ctrl.getCodeName())}${srfclassname(ctrltype)}Search(@Validated @RequestBody ${de.getCodeName()}SearchFilter searchFilter)throws Exception {
                    ${de.codeName}_Chart_${ctrl.codeName} chart =new ${de.codeName}_Chart_${ctrl.codeName}();
        chart.onInit();//准备|注册echars模型
        Page<${de.codeName}> searchResult = this.getService().searchDefault(searchFilter);//图表数据查询
        List<Map<String,Object>> iDataTable=chart.pageToListDatas(searchResult);//图表数据转换
                    ${pub.getPKGCodeName()}.ibizutil.chart.ECharts3Option echartsOption = ${pub.getPKGCodeName()}.ibizutil.chart.ECharts3Option.createEChartsOption(chart);//根据配置初始化echars模型
        echartsOption.loadDataTable(iDataTable);//模型载入数据
        JSONObject opt = echartsOption.getOptionJO();//返回最终的echars模型
        Page<JSONObject> searchResult_vo_data=chart.addRecordsToPage(opt);//将图表数据源转换成vo对象输出
        return ResponseEntity.ok().body(searchResult_vo_data);
    }
        </#if>
    </#if>
            </#if>
            </#if>
        </#list>
<#--    </#list>-->
    </#if>
				<#break>
			</#if>
		</#list>
	</#list>
</#if>
	/**
	 * 用于权限校验
	 * @return
	 */
	public ${de.codeName} getEntity(){
		return new ${de.codeName}();
	}
 }

